#ifndef LZ_BLENDOPS_GLSL
#define LZ_BLENDOPS_GLSL
/*
blendops.glsl
Helper functions implementing various common blending operations
*/

//vec4 versions
vec4 ColorOpacity(vec4 base, float opacity) {
	return (((base * 2 - vec4(1)) * opacity) + vec4(1))/2;
}

vec4 Darken(vec4 base, vec4 top) {
	return min(base, top);
}

vec4 Lighten(vec4 base, vec4 top) {
	return max(base, top);
}

vec4 Screen(vec4 base, vec4 top) {
	return vec4(1) - ((vec4(1) - base) * (vec4(1) - top));
}

vec4 Overlay(vec4 base, vec4 top) {
	vec4 outColor;
	for(int i=0; i<4; ++i) {
		if(base[i] < 0.5) {
			outColor[i] = 2*base[i]*top[i];
		}
		else {
			outColor[i] = 1 - 2*((1-base[i]) * (1-top[i]));
		}
	}

	return outColor;
}


vec4 ColorDodge(vec4 base, vec4 top) {
	//return base / (vec4(1) - top);

	return vec4(
		base.x <= 0.0f ? 0.0f : top.x >= 1.0f ? 1.0f : min(1.0f, base.x / (1 - top.x)),
		base.y <= 0.0f ? 0.0f : top.y >= 1.0f ? 1.0f : min(1.0f, base.y / (1 - top.y)),
		base.z <= 0.0f ? 0.0f : top.z >= 1.0f ? 1.0f : min(1.0f, base.z / (1 - top.z)),
		base.a <= 0.0f ? 0.0f : top.a >= 1.0f ? 1.0f : min(1.0f, base.a / (1 - top.a))
	);
}

vec4 LinearDodge(vec4 base, vec4 top) {
	return base + top;
}

vec4 ColorBurn(vec4 base, vec4 top) {
	//return vec4(1) - ((vec4(1) - base) / top);

	return vec4(
		base.x >= 1.0f ? 1.0f : top.x <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.x) / top.x),
		base.y >= 1.0f ? 1.0f : top.y <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.y) / top.y),
		base.z >= 1.0f ? 1.0f : top.z <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.z) / top.z),
		base.a >= 1.0f ? 1.0f : top.a <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.a) / top.a)
	);
}

vec4 LinearBurn(vec4 base, vec4 top) {
	return base + top - vec4(1);
}

//vec3 versions
vec3 ColorOpacity(vec3 base, float opacity) {
	return (((base * 2 - vec3(1)) * opacity) + vec3(1))/2;
}

vec3 Darken(vec3 base, vec3 top) {
	return min(base, top);
}

vec3 Lighten(vec3 base, vec3 top) {
	return max(base, top);
}

vec3 Screen(vec3 base, vec3 top) {
	return vec3(1) - ((vec3(1) - base) * (vec3(1) - top));
}

vec3 Overlay(vec3 base, vec3 top) {
	vec3 outColor;
	for(int i=0; i<3; ++i) {
		if(base[i] < 0.5) {
			outColor[i] = 2*base[i]*top[i];
		}
		else {
			outColor[i] = 1 - 2*((1-base[i]) * (1-top[i]));
		}
	}

	return outColor;
}


vec3 ColorDodge(vec3 base, vec3 top) {
	//return base / (vec3(1) - top);

	return vec3(
		base.x <= 0.0f ? 0.0f : top.x >= 1.0f ? 1.0f : min(1.0f, base.x / (1 - top.x)),
		base.y <= 0.0f ? 0.0f : top.y >= 1.0f ? 1.0f : min(1.0f, base.y / (1 - top.y)),
		base.z <= 0.0f ? 0.0f : top.z >= 1.0f ? 1.0f : min(1.0f, base.z / (1 - top.z))
	);
}

vec3 LinearDodge(vec3 base, vec3 top) {
	return base + top;
}

vec3 ColorBurn(vec3 base, vec3 top) {
	//return vec3(1) - ((vec3(1) - base) / top);
	
	return vec3(
		base.x >= 1.0f ? 1.0f : top.x <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.x) / top.x),
		base.y >= 1.0f ? 1.0f : top.y <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.y) / top.y),
		base.z >= 1.0f ? 1.0f : top.z <= 0.0f ? 0.0f : 1.0f - min(1.0f, (1 - base.z) / top.z)
	);

}

vec3 LinearBurn(vec3 base, vec3 top) {
	return base + top - vec3(1);
}
/*
* blendops.glsl end
*/
#endif